<?php

namespace App\Http\Controllers;

use App\Models\UserRole;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class UserRoleController extends Controller
{
    public function index(): JsonResponse
    {
        $userRoles = UserRole::with(['user', 'role'])->get();
        return response()->json([
            'status' => 'success',
            'data' => $userRoles,
        ], 200);
    }

    public function show($id): JsonResponse
    {
        $userRole = UserRole::with(['user', 'role'])->findOrFail($id);
        return response()->json([
            'status' => 'success',
            'data' => $userRole,
        ], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'User_id' => 'required|exists:Users,User_id',
            'Role_id' => 'required|exists:Roles,Role_id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $userRole = UserRole::create($request->only([
            'User_id',
            'Role_id',
        ]));

        return response()->json([
            'status' => 'success',
            'data' => $userRole,
        ], 201);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $userRole = UserRole::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'User_id' => 'sometimes|exists:Users,User_id',
            'Role_id' => 'sometimes|exists:Roles,Role_id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $userRole->update($request->only([
            'User_id',
            'Role_id',
        ]));

        return response()->json([
            'status' => 'success',
            'data' => $userRole,
        ], 200);
    }

    public function destroy($id): JsonResponse
    {
        $userRole = UserRole::findOrFail($id);
        $userRole->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'User role deleted successfully',
        ], 200);
    }
}
